---@meta

---@class FRuntimeArchiveEntry
---@field Index int32
---@field Name FString
---@field bIsDirectory boolean
---@field UncompressedSize int64
---@field CompressedSize int64
---@field CreationTime FDateTime
local FRuntimeArchiveEntry = {}



---@class URuntimeArchiverArchiveAsyncTask : UBlueprintAsyncActionBase
---@field OnSuccess FRuntimeArchiverArchiveAsyncTaskOnSuccess
---@field OnProgress FRuntimeArchiverArchiveAsyncTaskOnProgress
---@field OnFail FRuntimeArchiverArchiveAsyncTaskOnFail
---@field OperationResult FRuntimeArchiverArchiveAsyncTaskOperationResult
local URuntimeArchiverArchiveAsyncTask = {}

---@param bSuccess boolean
function URuntimeArchiverArchiveAsyncTask:OnResult_Callback(bSuccess) end
---@param Percentage int32
function URuntimeArchiverArchiveAsyncTask:OnProgress_Callback(Percentage) end
---@param ArchiverClass TSubclassOf<URuntimeArchiverBase>
---@param ArchivePath FString
---@param FilePaths TArray<FString>
---@param CompressionLevel ERuntimeArchiverCompressionLevel
---@return URuntimeArchiverArchiveAsyncTask
function URuntimeArchiverArchiveAsyncTask:ArchiveFiles(ArchiverClass, ArchivePath, FilePaths, CompressionLevel) end
---@param ArchiverClass TSubclassOf<URuntimeArchiverBase>
---@param ArchivePath FString
---@param DirectoryPath FString
---@param bAddParentDirectory boolean
---@param CompressionLevel ERuntimeArchiverCompressionLevel
---@return URuntimeArchiverArchiveAsyncTask
function URuntimeArchiverArchiveAsyncTask:ArchiveDirectory(ArchiverClass, ArchivePath, DirectoryPath, bAddParentDirectory, CompressionLevel) end


---@class URuntimeArchiverBase : UObject
local URuntimeArchiverBase = {}

---@param ArchivePath FString
---@return boolean
function URuntimeArchiverBase:OpenArchiveFromStorage(ArchivePath) end
---@param ArchiveData TArray<uint8>
---@return boolean
function URuntimeArchiverBase:OpenArchiveFromMemory(ArchiveData) end
---@param EntryName FString
---@param EntryInfo FRuntimeArchiveEntry
---@return boolean
function URuntimeArchiverBase:GetArchiveEntryInfoByName(EntryName, EntryInfo) end
---@param EntryIndex int32
---@param EntryInfo FRuntimeArchiveEntry
---@return boolean
function URuntimeArchiverBase:GetArchiveEntryInfoByIndex(EntryIndex, EntryInfo) end
---@param NumOfArchiveEntries int32
---@return boolean
function URuntimeArchiverBase:GetArchiveEntries(NumOfArchiveEntries) end
---@param ArchiveData TArray<uint8>
---@return boolean
function URuntimeArchiverBase:GetArchiveData(ArchiveData) end
---@param EntryInfo FRuntimeArchiveEntry
---@param FilePath FString
---@param bForceOverwrite boolean
---@return boolean
function URuntimeArchiverBase:ExtractEntryToStorage(EntryInfo, FilePath, bForceOverwrite) end
---@param EntryInfo FRuntimeArchiveEntry
---@param UnarchivedData TArray<uint8>
---@return boolean
function URuntimeArchiverBase:ExtractEntryToMemory(EntryInfo, UnarchivedData) end
---@param OnResult FExtractEntriesToStorage_DirectoryOnResult
---@param EntryName FString
---@param DirectoryPath FString
---@param bAddParentDirectory boolean
---@param bForceOverwrite boolean
function URuntimeArchiverBase:ExtractEntriesToStorage_Directory(OnResult, EntryName, DirectoryPath, bAddParentDirectory, bForceOverwrite) end
---@param OnResult FExtractEntriesToStorageOnResult
---@param OnProgress FExtractEntriesToStorageOnProgress
---@param EntryInfo TArray<FRuntimeArchiveEntry>
---@param DirectoryPath FString
---@param bForceOverwrite boolean
function URuntimeArchiverBase:ExtractEntriesToStorage(OnResult, OnProgress, EntryInfo, DirectoryPath, bForceOverwrite) end
---@param WorldContextObject UObject
---@param ArchiverClass TSubclassOf<URuntimeArchiverBase>
---@return URuntimeArchiverBase
function URuntimeArchiverBase:CreateRuntimeArchiver(WorldContextObject, ArchiverClass) end
---@param ArchivePath FString
---@return boolean
function URuntimeArchiverBase:CreateArchiveInStorage(ArchivePath) end
---@param InitialAllocationSize int32
---@return boolean
function URuntimeArchiverBase:CreateArchiveInMemory(InitialAllocationSize) end
---@return boolean
function URuntimeArchiverBase:CloseArchive() end
---@param EntryName FString
---@param FilePath FString
---@param CompressionLevel ERuntimeArchiverCompressionLevel
---@return boolean
function URuntimeArchiverBase:AddEntryFromStorage(EntryName, FilePath, CompressionLevel) end
---@param EntryName FString
---@param DataToBeArchived TArray<uint8>
---@param CompressionLevel ERuntimeArchiverCompressionLevel
---@return boolean
function URuntimeArchiverBase:AddEntryFromMemory(EntryName, DataToBeArchived, CompressionLevel) end
---@param DirectoryPath FString
---@param bAddParentDirectory boolean
---@param CompressionLevel ERuntimeArchiverCompressionLevel
---@return boolean
function URuntimeArchiverBase:AddEntriesFromStorage_DirectorySync(DirectoryPath, bAddParentDirectory, CompressionLevel) end
---@param OnResult FAddEntriesFromStorage_DirectoryOnResult
---@param DirectoryPath FString
---@param bAddParentDirectory boolean
---@param CompressionLevel ERuntimeArchiverCompressionLevel
function URuntimeArchiverBase:AddEntriesFromStorage_Directory(OnResult, DirectoryPath, bAddParentDirectory, CompressionLevel) end
---@param OnResult FAddEntriesFromStorageOnResult
---@param OnProgress FAddEntriesFromStorageOnProgress
---@param FilePaths TArray<FString>
---@param CompressionLevel ERuntimeArchiverCompressionLevel
function URuntimeArchiverBase:AddEntriesFromStorage(OnResult, OnProgress, FilePaths, CompressionLevel) end


---@class URuntimeArchiverGZip : URuntimeArchiverBase
local URuntimeArchiverGZip = {}


---@class URuntimeArchiverLZ4 : URuntimeArchiverBase
local URuntimeArchiverLZ4 = {}


---@class URuntimeArchiverOodle : URuntimeArchiverBase
local URuntimeArchiverOodle = {}


---@class URuntimeArchiverRaw : UObject
local URuntimeArchiverRaw = {}

---@param RawFormat ERuntimeArchiverRawFormat
---@param CompressedData TArray<uint8>
---@param OnResult FUncompressRawDataAsyncOnResult
function URuntimeArchiverRaw:UncompressRawDataAsync(RawFormat, CompressedData, OnResult) end
---@param RawFormat ERuntimeArchiverRawFormat
---@param CompressionLevel ERuntimeArchiverCompressionLevel
---@param UncompressedData TArray<uint8>
---@param OnResult FCompressRawDataAsyncOnResult
function URuntimeArchiverRaw:CompressRawDataAsync(RawFormat, CompressionLevel, UncompressedData, OnResult) end


---@class URuntimeArchiverSubsystem : UEngineSubsystem
---@field OnError FRuntimeArchiverSubsystemOnError
local URuntimeArchiverSubsystem = {}



---@class URuntimeArchiverTar : URuntimeArchiverBase
local URuntimeArchiverTar = {}


---@class URuntimeArchiverUnarchiveAsyncTask : UBlueprintAsyncActionBase
---@field OnSuccess FRuntimeArchiverUnarchiveAsyncTaskOnSuccess
---@field OnProgress FRuntimeArchiverUnarchiveAsyncTaskOnProgress
---@field OnFail FRuntimeArchiverUnarchiveAsyncTaskOnFail
---@field OperationResult FRuntimeArchiverUnarchiveAsyncTaskOperationResult
local URuntimeArchiverUnarchiveAsyncTask = {}

---@param ArchiverClass TSubclassOf<URuntimeArchiverBase>
---@param ArchivePath FString
---@param EntryNames TArray<FString>
---@param DirectoryPath FString
---@param bForceOverwrite boolean
---@return URuntimeArchiverUnarchiveAsyncTask
function URuntimeArchiverUnarchiveAsyncTask:UnarchiveFiles(ArchiverClass, ArchivePath, EntryNames, DirectoryPath, bForceOverwrite) end
---@param ArchiverClass TSubclassOf<URuntimeArchiverBase>
---@param ArchivePath FString
---@param EntryName FString
---@param DirectoryPath FString
---@param bAddParentDirectory boolean
---@param bForceOverwrite boolean
---@return URuntimeArchiverUnarchiveAsyncTask
function URuntimeArchiverUnarchiveAsyncTask:UnarchiveDirectory(ArchiverClass, ArchivePath, EntryName, DirectoryPath, bAddParentDirectory, bForceOverwrite) end
---@param bSuccess boolean
function URuntimeArchiverUnarchiveAsyncTask:OnResult_Callback(bSuccess) end
---@param Percentage int32
function URuntimeArchiverUnarchiveAsyncTask:OnProgress_Callback(Percentage) end


---@class URuntimeArchiverUtilities : UObject
local URuntimeArchiverUtilities = {}

---@param FilePath FString
---@return TArray<FString>
function URuntimeArchiverUtilities:ParseDirectories(FilePath) end


---@class URuntimeArchiverZip : URuntimeArchiverBase
local URuntimeArchiverZip = {}

---@param ArchivePath FString
---@return boolean
function URuntimeArchiverZip:OpenArchiveFromStorageToAppend(ArchivePath) end


